<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tank extends Model 
{

    protected $table = 'tanks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('abacus', 'diameter', 'liquid_type', 'file_path', 'man_hole_height', 'sensor_depth', 'sensor_reference', 'level_active_depotage', 'product_station_tank_id', 'jauge_id');
    protected $visible = array('abacus', 'diameter', 'liquid_type', 'file_path', 'man_hole_height', 'sensor_depth', 'sensor_reference', 'level_active_depotage', 'product_station_tank_id', 'jauge_id');

    public function jauge()
    {
        return $this->belongsTo('Jauge', 'jauge_id');
    }

    public function product_station_tank()
    {
        return $this->belongsTo('ProductStationTank', 'product_station_tank_id');
    }

    public function depotages()
    {
        return $this->hasMany('Depotage');
    }

    public function records()
    {
        return $this->hasMany('Record');
    }

    public function notifications()
    {
        return $this->hasMany('Notification');
    }

    public function correction_data()
    {
        return $this->hasOne('CorrecttionData');
    }

}